package com.androidbook.simpledialogs;

import java.util.Calendar;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.text.method.CharacterPickerDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

public class SimpleDialogsActivity extends Activity {

    static final int BASIC_DIALOG_ID = 0;
    static final int ALERT_DIALOG_ID = 1;
    static final int CHARACTER_DIALOG_ID = 2;
    static final int DATE_DIALOG_ID = 3;
    static final int PROGRESS_DIALOG_ID = 4;
    static final int TIME_DIALOG_ID = 5;
    static final int CUSTOM_DIALOG_ID = 6;

    /** Wywoływana podczas pierwszego wykonania aktywności. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
             
        
        // OBSŁUGA KLIKNIĘĆ PRZYCISKÓW
        
        // Obsługa przycisku komunikatu Toast
        Button launchToast = (Button) findViewById(R.id.Button_Toast);
        launchToast.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	Toast.makeText(SimpleDialogsActivity.this, "Oto bardzo prosty komunikat informacyjny", Toast.LENGTH_SHORT).show();
            }
        });
        
        // Obsługa przycisku okna dialogowego
        Button launchBasicDialog = (Button) findViewById(R.id.Button_SimpleDialog);
        launchBasicDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(BASIC_DIALOG_ID);
            }
        });
        
        // Obsługa przycisku ostrzegawczego okna dialogowego
        Button launchAlertDialog = (Button) findViewById(R.id.Button_AlertDialog);
        launchAlertDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(ALERT_DIALOG_ID);
            }
        }); 
        // Obsługa przycisku wyboru znaku
        Button launchCharDialog = (Button) findViewById(R.id.Button_CharacterPickerDialog);
        launchCharDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(CHARACTER_DIALOG_ID);
            }
        });
        // Obsługa przycisku wyboru daty
        Button launchDateDialog = (Button) findViewById(R.id.Button_DatePickerDialog);
        launchDateDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(DATE_DIALOG_ID);
            }
        });
        // Obsługa przycisku okna postępów
        Button launchProgressDialog = (Button) findViewById(R.id.Button_ProgressDialog);
        launchProgressDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(PROGRESS_DIALOG_ID);
            }
        });
        
        // Obsługa przycisku wyboru godziny
        Button launchTimeDialog = (Button) findViewById(R.id.Button_TimePickerDialog);
        launchTimeDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(TIME_DIALOG_ID);
            }
        });
        // Obsługa przycisku niestandardowego okna dialogowego
        Button launchCustomDialog = (Button) findViewById(R.id.Button_CustomDialog);
        launchCustomDialog.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	showDialog(CUSTOM_DIALOG_ID);
            }
        });
        }
    
    @Override
    protected Dialog onCreateDialog(int id) {
        switch (id) {
        
	        case BASIC_DIALOG_ID:
	            Dialog simpleDialog = new Dialog(this);
	            simpleDialog.setTitle("Proste okno dialogowe");
	            return simpleDialog;
	        case ALERT_DIALOG_ID:
	            
	            AlertDialog alertDialog = new AlertDialog.Builder(this)
    	            .setTitle("Okno dialogowe Alert")
    	            .setMessage("Zostałeś ostrzeżony.")
    	            .setNeutralButton("OK", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            // TODO Auto-generated method stub
                            Toast.makeText(SimpleDialogsActivity.this, "Super", Toast.LENGTH_SHORT);
                        }
                    })
                    .setNegativeButton("Anuluj", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            // TODO Auto-generated method stub
                            Toast.makeText(SimpleDialogsActivity.this, "Anulowano", Toast.LENGTH_SHORT);
                        }
                    })
    	            .create();


	            return alertDialog;
	        case CHARACTER_DIALOG_ID:
	            // ****************************************************
	            // UWAGA UWAGA UWAGA UWAGA
	            // Co do tegonie mamy pewności. Działa i okienko się wyświetla, ale...
	            CharacterPickerDialog charDialog = new CharacterPickerDialog(this, new View(this), null, "ąćęłńóśźż", false) {

	                /* jeśli ta metoda nie zostanie przesłonięta, naciśnięcie jednego z przycisków powoduje awarię */
                    @Override
                    public void onItemClick(AdapterView parent, View view,
                            int position, long id) {

                    }

                    @Override
                    public void onClick(View v) {

                    }

	            };
	            charDialog.setTitle( "Wybór znaku" );
	            
	            return charDialog;
	        case DATE_DIALOG_ID:
	            DatePickerDialog dateDialog = new DatePickerDialog(this, new DatePickerDialog.OnDateSetListener() {
	                public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
	                    Time dtOfInterest = new Time();
	                    dtOfInterest.set(dayOfMonth, monthOfYear, year);
	                    long dtDob = dtOfInterest.toMillis(true);
	                    CharSequence strDate = DateFormat.format("dd MMMM yyyy", dtDob);
	                    Toast.makeText(SimpleDialogsActivity.this, strDate, Toast.LENGTH_SHORT).show();
	                }
	            }, 2011,1, 1);
	            
	            dateDialog.setTitle("Podaj datę");
	            dateDialog.setMessage("Tylko się dobrze zastanów...");
	            
	            return dateDialog;
	        case PROGRESS_DIALOG_ID:
	            ProgressDialog progressDialog = new ProgressDialog(this);
	            progressDialog.setIndeterminate(true);
	            progressDialog.setTitle("Prezentacja postępów");
	            progressDialog.setMessage("Houston, robimy postępy!");
	            return progressDialog;
	        case TIME_DIALOG_ID: 
	            TimePickerDialog timeDialog = new TimePickerDialog(this, new TimePickerDialog.OnTimeSetListener() {
                    
                    @Override
                    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                        Toast.makeText(SimpleDialogsActivity.this, "Wybrałeś następujący czas: godzina "+hourOfDay+" minut "+minute+"." , Toast.LENGTH_SHORT).show();
                        
                    }
                }, 0, 0, true);
	            
	            timeDialog.setMessage("Nie spiesz się...");
	            return timeDialog;
	        case CUSTOM_DIALOG_ID:
	        	  LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	              final View layout = inflater.inflate(R.layout.custom_dialog, (ViewGroup) findViewById(R.id.root));
	              final EditText p1 = (EditText) layout.findViewById(R.id.EditText_Pwd1);
	              final EditText p2 = (EditText) layout.findViewById(R.id.EditText_Pwd2);
	              final TextView error = (TextView) layout.findViewById(R.id.TextView_PwdProblem);
	              p2.addTextChangedListener(new TextWatcher() {
	                  @Override
	                  public void afterTextChanged(Editable s) {
	                      String strPass1 = p1.getText().toString();
	                      String strPass2 = p2.getText().toString();
	                      if (strPass1.equals(strPass2)) {
	                          error.setText(R.string.settings_pwd_equal);
	                      } else {
	                          error.setText(R.string.settings_pwd_not_equal);
	                      }
	                  }
	
	                  // ... inne metody, które trzeba przesłonić nie muszą nic robić
	                  @Override
	                  public void beforeTextChanged(CharSequence s, int start, int count, int after) {
	                  }
	
	                  @Override
	                  public void onTextChanged(CharSequence s, int start, int before, int count) {
	                  }
	              });
	              AlertDialog.Builder builder = new AlertDialog.Builder(this);
	              builder.setView(layout);
	              // KOnfiguracja okna AlertDialog
	              builder.setTitle(R.string.password_title);
	              builder.setNegativeButton(android.R.string.cancel, new DialogInterface.OnClickListener() {
	                  public void onClick(DialogInterface dialog, int whichButton) {
	                      // Wymuszamy zamknięcie i usunięcie okna, tak by nie można
	                      // było ponownie z niego skorzystać.
	                      removeDialog(CUSTOM_DIALOG_ID);
	                  }
	              });
	              builder.setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
	                  public void onClick(DialogInterface dialog, int which) {
	                      String strPassword1 = p1.getText().toString();
	                      String strPassword2 = p2.getText().toString();
	                      if (strPassword1.equals(strPassword2)) {
	                    	  Toast.makeText(SimpleDialogsActivity.this, "Pasujące hasło="+strPassword2, Toast.LENGTH_SHORT).show();
	                      } 
                          // Wymuszamy zamknięcie i usunięcie okna, tak by nie można
                          // było ponownie z niego skorzystać.
	                      removeDialog(CUSTOM_DIALOG_ID);
	                  }
	              });
	              // Twrozymy obiekt AlertDialog i zwracamy go.
	              AlertDialog passwordDialog = builder.create();
	              return passwordDialog;
	          }
        return null;
    }

    @Override
    protected void onPrepareDialog(int id, Dialog dialog) {
        super.onPrepareDialog(id, dialog);
        switch (id) {
        case DATE_DIALOG_ID:
            // Tu można umieścić dowolne czynności związane z inicjalizacją okna DatePickerDialog.
            DatePickerDialog dateDialog = (DatePickerDialog) dialog;
            int iDay,iMonth,iYear;

            // Zawsze należy umieścić w oknie dialogowym bieżącą datę.
            Calendar cal = Calendar.getInstance();
            iDay = cal.get(Calendar.DAY_OF_MONTH);
            iMonth = cal.get(Calendar.MONTH);
            iYear = cal.get(Calendar.YEAR);
            dateDialog.updateDate(iYear, iMonth, iDay);
            return;
        case TIME_DIALOG_ID:
            // Tu można umieścić dowolne czynności związane z inicjalizacją okna TimePickerDialog.
            TimePickerDialog timeDialog = (TimePickerDialog) dialog;
            int iHour,iMinute;

            // Zawsze należy umieścić w oknie dialogowym bieżący czas.
            Calendar cal1 = Calendar.getInstance();
            iHour = cal1.get(Calendar.HOUR_OF_DAY);
            iMinute = cal1.get(Calendar.MINUTE);
            timeDialog.updateTime(iHour, iMinute);
            return;
        case CUSTOM_DIALOG_ID:
            // Tu można umieścić dowolne czynności związane z inicjalizacją naszego
            // niestandardowego okna dialogowego do podawania hasła.
            // Ponieważ nie chcemy wyświetlać starych okien dialogowych lecz użyć nowych,
            // zatem nie musimy tu nic robić.
            // Dzieje się tak, gdyż nie używamy tego samego okna wielokrotnie po jego 
            // zamknięciu, lecz jawnie usuwamy z puli okien używając megody removeDialog(),
            // a później, w razie konieczności, tworzymy nowe okno.
            return;
        }
    }
}